<?php
namespace App\Controllers;

use App\Libraries\CIAuth;
use App\Libraries\PanelAPI;

class Login extends BaseController {
    
    public function __construct(){
        $this->panel = new PanelAPI();
    }
    
    public function index() {
        if(CIAuth::check()){
            return redirect()->to(base_url());
        }
        
        $data = [ 
            'mata_title' => 'Sign In',
            'menu_active' => 'Sign In'
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        return view('page_login', $data);
    }
    
    public function user_login_validate() { 
        
        $username =  $this->request->getVar('user_login');  
        $password = $this->request->getVar('user_pass');
        
        if (empty($username) || empty($password)) {
            $message = array('message' => "Username and Password fields cannot be empty", 'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('login'));
        }
        
        $query = $this->panel->getUserLogin($username, $password);
        if(!empty($query)){
            if($query['success']=='1') {
                
                CIAuth::setCIAuth($query);
                
                $message = array('message' => $query['MSG'],'class' => 'success');
                session()->set('response_msg', $message);
                return redirect()->to(base_url());
            }
            else {
                $message = array('message' => $query['MSG'],'class' => 'error');
                session()->set('response_msg', $message);
                return redirect()->to(base_url('login'));
            }
        } else {
            $message = array('message' => "Server not connected !",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('login'));
        }
    }
    
    public function logout(){
        CIAuth::forget();
        $message = array('message' => 'Logged out successfully.','class' => 'success');
        session()->set('response_msg', $message);
        return redirect()->to(base_url());
    }
    
    public function profile(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id =  CIAuth::id();
            
        $data = [ 
            'mata_title' => 'profile',
            'menu_active' => 'profile'
        ];
        
        $data['noti_data']  = $this->panel->getUserNotification($user_id);
        $data['user_data']  = CIAuth::user();
        
        $data['details'] = $this->panel->getWebDetails();
        return view('page_profile', $data);
    }
    
    public function profile_update(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id = CIAuth::id();
        $user_email =  $this->request->getVar('user_email');  
        $user_name = $this->request->getVar('user_name');
        $user_phone = $this->request->getVar('user_phone');
        $user_gender = $this->request->getVar('user_gender');
        
        $data = $this->panel->setProfileUpdate($user_id, $user_email, $user_name, $user_phone, $user_gender);
        
        if(!empty($data)){
            if($data['success']=='1'){
                CIAuth::forget();
                
                $message = array('message' => $data['MSG'], 'class' => 'success');
                session()->set('response_msg', $message);
                return redirect()->to(base_url());
            } else {
                $message = array('message' => $data['MSG'], 'class' => 'error');
            }
        } else {
            $message = array('message' => 'Server not connected !', 'class' => 'error');
        }
        
        session()->set('response_msg', $message);
        return redirect()->to(base_url() . '/profile');
    }
    
    public function profile_pass_update(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id = CIAuth::id();
        $user_pass = $this->request->getVar('register_password');
        $conf_user_pass = $this->request->getVar('register_confirm_password');
        
        if(empty($user_pass)){
            $message = array('message' => "Please Enter Password",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('profile'));
        } else if(empty($conf_user_pass)){
            $message = array('message' => "Please Enter Confirm Password",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('profile'));
        } else if($user_pass == $conf_user_pass) {

            $data = $this->panel->setPasswordUpdate($user_id, $user_pass);
            if(!empty($data)){
                if($data['success']=='1'){
                    CIAuth::forget();
                    $message = array('message' => $data['MSG'], 'class' => 'success');
                    session()->set('response_msg', $message);
                    return redirect()->to(base_url('login'));
                } else {
                    $message = array('message' => $data['MSG'], 'class' => 'error');
                    session()->set('response_msg', $message);
                    return redirect()->to(base_url('profile'));
                }
            } else {
                $message = array('message' => 'Server not connected !', 'class' => 'error');
                session()->set('response_msg', $message);
                return redirect()->to(base_url('profile'));
            }
        } else {
            $message = array('message' => "Confirm password not matched",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('profile'));
        }
    }
    
    public function notification_update(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id =  CIAuth::id();
        $data = $this->panel->clearNotification($user_id);
        
        if(!empty($data)){
            $statusClass = ($data['success'] == '1') ? 'success' : 'error';
            $message = array('message' => $data['MSG'], 'class' => $statusClass);
        } else {
            $message = array('message' => 'Server not connected !', 'class' => 'error');
        }
        
        session()->set('response_msg', $message);
        return redirect()->to(base_url() . '/profile');
    }
    
    public function suggestion_add() { 
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $data = [
            'mata_title' => 'Add Suggestion',
            'menu_active' => 'suggestion'
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        return view('add_suggestion',$data);
    }
    
    public function suggestion_store() { 
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id =  CIAuth::id();
        $title = $this->request->getVar('suggestion_title');
        $desc =  $this->request->getVar('suggestion_description');
        
        $data = $this->panel->addSuggestion($user_id, $title, $desc);
        if(!empty($data)){
            $statusClass = ($data['success'] == '1') ? 'success' : 'error';
            $message = array('message' => $data['MSG'], 'class' => $statusClass);
        } else {
            $message = array('message' => 'Server not connected !', 'class' => 'error');
        }
        
        session()->set('response_msg', $message);
        return redirect()->to(base_url());
    }
    
    public function reports_id($id) {
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $data = [
            'mata_title' => 'Reports',
            'menu_active' => 'reports'
        ];
        
        $row_data = $this->panel->getRadioId($id);
        
        $data['report_title'] = $row_data['radio_list'][0]['radio_title'];
        $data['song_id'] = $row_data['radio_list'][0]['id'];
        
        $data['details'] = $this->panel->getWebDetails();
        return view('reports',$data);
    }
    
    public function reports_store(){
        if(!CIAuth::check()){
            return redirect()->to(base_url('login'));
        }
        
        $user_id = CIAuth::id();
        $post_id = $this->request->getVar('song_id');
        $report_title = $this->request->getVar('report_title');
        $report_desc =  $this->request->getVar('report_desc');
        
        $data = $this->panel->setReports($user_id, $post_id, $report_title, $report_desc);
        
        if(!empty($data)){
            $statusClass = ($data['success'] == '1') ? 'success' : 'error';
            $message = array('message' => $data['MSG'], 'class' => $statusClass);
        } else {
            $message = array('message' => 'Server not connected !', 'class' => 'error');
        }
        
        session()->set('response_msg', $message);
        return redirect()->to(base_url());
    }
    
    public function register_index() {
        if(CIAuth::check()){
            return redirect()->to(base_url());
        }
        
        $data = [
            'mata_title' => 'Register',
            'menu_active' => 'register'
        ];
        
        $data['details'] = $this->panel->getWebDetails();
        return view('page_register', $data);
    }
    
    public function register_store() { 
        
        $user_email = $this->request->getVar('user_email');
        $user_name =  $this->request->getVar('user_name');
        $user_phone = $this->request->getVar('user_phone'); 
        $user_pass = $this->request->getVar('user_pass'); 
        $conf_user_pass = $this->request->getVar('conf_user_pass'); 
        $user_gender = $this->request->getVar('user_gender'); 
        
        if(empty($user_email)){
            $message = array('message' => "Please enter email address.",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('register'));
        } 
        
        if(empty($user_name)){
            $message = array('message' => "Please enter user name.",'class' => 'error');
            session()->set('response_msg', $message);
           return redirect()->to(base_url('register'));
        }
        
        if(empty($user_gender)){
            $message = array('message' => "User gender is not found !",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('register'));
        }
        
        if(empty($user_pass)){
            $message = array('message' => "Please enter password.",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('register'));
        }
        
        if(empty($conf_user_pass)){
            $message = array('message' => "Please enter password.",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('register'));
        }
        
        if ($user_pass !== $conf_user_pass) {
            $message = array('message' => "Confirm Password not matched",'class' => 'error');
            session()->set('response_msg', $message);
            return redirect()->to(base_url('register'));
        }
        
        $data = $this->panel->setRegister($user_email, $user_name, $user_phone, $user_pass, $user_gender);
        if(!empty($data)){
            $statusClass = ($data['success'] == '1') ? 'success' : 'error';
            $message = array('message' => $data['MSG'], 'class' => $statusClass);
        } else {
            $message = array('message' => 'Server not connected !', 'class' => 'error');
        }
        
        session()->set('response_msg', $message);
        return redirect()->to(base_url('login'));
    }
}